﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.Text;

namespace WCFStocksWS
{
    // NOTE: If you change the interface name "IService1" here, you must also update the reference to "IService1" in Web.config.
    [ServiceContract(
        Name = "StockService",
        Namespace = "http://www.learn2develop.net/",
        CallbackContract = typeof(IStockReminderCallBack),
        SessionMode = SessionMode.Required)]

    public interface IStockService
    {
        //---called by the client---
        [OperationContract(IsOneWay = true)]
        void SetStockReminder(string symbol, float price);
    }

    public interface IStockReminderCallBack
    {
        //---implemented by the client---
        [OperationContract(IsOneWay = true)]
        void StockReminder(string message);
    }
}
